/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.core.spawning;

import com.lycanitesmobs.core.spawning.SpawnTypeBase;
import com.lycanitesmobs.core.spawning.SpawnTypeBlockBreak;
import com.lycanitesmobs.core.spawning.SpawnTypeDeath;
import com.lycanitesmobs.core.spawning.SpawnTypeFishing;
import com.lycanitesmobs.core.spawning.SpawnTypeSleep;
import com.lycanitesmobs.core.spawning.SpawnTypeStorm;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityFishHook;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.player.ItemFishedEvent;
import net.minecraftforge.event.entity.player.PlayerSleepInBedEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class CustomSpawner {
    public static CustomSpawner instance;
    public List<SpawnTypeBase> updateSpawnTypes = new ArrayList<SpawnTypeBase>();
    public Map<EntityPlayer, Long> entityUpdateTicks = new HashMap<EntityPlayer, Long>();
    public List<SpawnTypeDeath> deathSpawnTypes = new ArrayList<SpawnTypeDeath>();
    public List<SpawnTypeBlockBreak> blockSpawnTypes = new ArrayList<SpawnTypeBlockBreak>();
    public List<SpawnTypeSleep> sleepSpawnTypes = new ArrayList<SpawnTypeSleep>();
    public List<SpawnTypeFishing> fishingTypes = new ArrayList<SpawnTypeFishing>();
    public List<SpawnTypeStorm> lightningStrikeTypes = new ArrayList<SpawnTypeStorm>();

    public CustomSpawner() {
        instance = this;
    }

    @SubscribeEvent
    public void onEntityUpdate(LivingEvent.LivingUpdateEvent event) {
        EntityLivingBase entity = event.getEntityLiving();
        if (entity == null || !(entity instanceof EntityPlayer) || entity.func_130014_f_() == null || entity.func_130014_f_().field_72995_K || event.isCanceled()) {
            return;
        }
        EntityPlayer player = (EntityPlayer)entity;
        World world = player.func_130014_f_();
        if (!this.entityUpdateTicks.containsKey(player)) {
            this.entityUpdateTicks.put(player, 0L);
        }
        long entityUpdateTick = this.entityUpdateTicks.get(player);
        int tickOffset = 0;
        for (SpawnTypeBase spawnType : this.updateSpawnTypes) {
            spawnType.spawnMobs(entityUpdateTick - (long)tickOffset, world, player.func_180425_c(), player);
            tickOffset += 105;
        }
        this.entityUpdateTicks.put(player, entityUpdateTick + 1L);
    }

    @SubscribeEvent
    public void onEntityDeath(LivingDeathEvent event) {
        EntityLivingBase entity = event.getEntityLiving();
        if (entity == null || entity.func_130014_f_() == null || entity.func_130014_f_().field_72995_K || event.isCanceled()) {
            return;
        }
        Entity killerEntity = event.getSource().func_76364_f();
        if (!(killerEntity instanceof EntityLivingBase)) {
            return;
        }
        EntityLivingBase killer = (EntityLivingBase)killerEntity;
        if (!(killer instanceof EntityPlayer) && !(entity instanceof EntityPlayer)) {
            return;
        }
        World world = entity.func_130014_f_();
        for (SpawnTypeDeath spawnType : this.deathSpawnTypes) {
            if (!spawnType.isValidKill(entity, killer)) continue;
            spawnType.spawnMobs(0L, world, entity.func_180425_c(), null);
        }
    }

    @SubscribeEvent
    public void onHarvestDrops(BlockEvent.HarvestDropsEvent event) {
        EntityPlayer player = event.getHarvester();
        if (event.getState() == null || event.getWorld() == null || event.getWorld().field_72995_K || event.isCanceled()) {
            return;
        }
        if (player != null && player.field_71075_bZ.field_75098_d) {
            return;
        }
        World world = event.getWorld();
        BlockPos spawnPos = event.getPos().func_177982_a(0, 0, 1);
        for (SpawnTypeBlockBreak spawnType : this.blockSpawnTypes) {
            if (!spawnType.validBlockHarvest(event.getState().func_177230_c(), world, spawnPos, (Entity)player)) continue;
            spawnType.spawnMobs(0L, world, spawnPos, player, event.getState().func_177230_c());
        }
    }

    @SubscribeEvent
    public void onBlockBreak(BlockEvent.BreakEvent event) {
        EntityPlayer player = event.getPlayer();
        if (event.getState().func_177230_c() == null || event.getWorld() == null || event.getWorld().field_72995_K || event.isCanceled()) {
            return;
        }
        if (player == null || player != null && player.field_71075_bZ.field_75098_d) {
            return;
        }
        World world = event.getWorld();
        BlockPos spawnPos = event.getPos().func_177982_a(0, 0, 1);
        for (SpawnTypeBlockBreak spawnType : this.blockSpawnTypes) {
            if (!spawnType.validBlockBreak(event.getState().func_177230_c(), world, spawnPos, (Entity)player)) continue;
            spawnType.spawnMobs(0L, world, spawnPos, player);
        }
    }

    @SubscribeEvent
    public void onSleep(PlayerSleepInBedEvent event) {
        EntityPlayer player = event.getEntityPlayer();
        if (player == null || event.isCanceled()) {
            return;
        }
        World world = player.func_130014_f_();
        BlockPos spawnPos = event.getPos().func_177982_a(0, 0, 1);
        if (world == null || world.field_72995_K || world.field_73011_w.isDaytime()) {
            return;
        }
        boolean interrupted = false;
        for (SpawnTypeBase spawnTypeBase : this.sleepSpawnTypes) {
            if (!spawnTypeBase.spawnMobs(0L, world, spawnPos, player)) continue;
            interrupted = true;
        }
        if (interrupted) {
            event.setResult(EntityPlayer.SleepResult.NOT_SAFE);
        }
    }

    public void onFished(ItemFishedEvent event) {
        EntityPlayer player = event.getEntityPlayer();
        if (player == null || event.isCanceled()) {
            return;
        }
        World world = player.func_130014_f_();
        BlockPos spawnPos = player.func_180425_c().func_177982_a(0, 0, 1);
        EntityFishHook hookEntity = event.getHookEntity();
        if (hookEntity != null) {
            spawnPos = hookEntity.func_180425_c();
        }
        for (SpawnTypeFishing spawnType : this.fishingTypes) {
            spawnType.setHookEntity((Entity)hookEntity);
            spawnType.spawnMobs(0L, world, spawnPos, player);
        }
    }

    public void onLightningStrike() {
    }
}

